"use client"

import React from "react"
import { Button } from "@/components/ui/button"
import { Card } from "@/components/ui/card"
import Link from "next/link"
import { Menu, X, ArrowRight, Target, CheckCircle, Star, Clock, TrendingUp } from "lucide-react"
import Image from "next/image"

export default function DigitalStrategyPage() {
  const [isMenuOpen, setIsMenuOpen] = React.useState(false)

  return (
    <div className="min-h-screen bg-white text-gray-900">
      {/* Header */}
      <header className="sticky top-0 z-50 backdrop-blur-3xl bg-[#161d25]/95 border-b border-white/10 shadow-2xl">
        <div className="container mx-auto px-4 py-6 relative">
          <div className="flex items-center justify-between">
            <Link href="/" className="flex items-center gap-4">
              <div className="relative group">
                <Image
                  src="https://i.ibb.co/5XLC8VTC/kdsgnpng2.png"
                  alt="Kristijan Digital"
                  width={40}
                  height={40}
                  className="rounded-2xl shadow-lg transition-transform duration-700 group-hover:scale-105 relative z-10"
                />
              </div>
              <div>
                <h1 className="text-2xl font-bold text-white">kristijan.digital</h1>
                <p className="text-xs text-white/60 font-medium">Digital Innovation Specialist</p>
              </div>
            </Link>

            {/* Desktop Navigation */}
            <nav className="hidden lg:flex items-center gap-12">
              {[
                { href: "/", label: "Home" },
                { href: "/#about", label: "About" },
                { href: "/services", label: "Services" },
                { href: "/#projects", label: "Projects" },
                { href: "/contact", label: "Contact" },
              ].map((item) => (
                <Link
                  key={item.label}
                  href={item.href}
                  className="text-sm font-medium text-white/70 hover:text-white hover:scale-110 transition-all duration-500 relative group"
                >
                  {item.label}
                  <div className="absolute -bottom-2 left-0 w-0 h-0.5 bg-gradient-to-r from-gray-400 to-gray-300 group-hover:w-full transition-all duration-500"></div>
                </Link>
              ))}
            </nav>

            <div className="flex items-center gap-6">
              <Link href="/contact">
                <Button className="hidden lg:flex bg-gradient-to-r from-white/15 to-white/10 backdrop-blur-xl border border-white/30 hover:bg-gradient-to-r hover:from-white/25 hover:to-white/20 hover:border-white/50 shadow-xl hover:shadow-2xl hover:shadow-white/20 transition-all duration-500 hover:scale-105 rounded-xl px-8 py-3 font-semibold text-white">
                  Get Started
                  <ArrowRight className="ml-2 h-4 w-4" />
                </Button>
              </Link>

              {/* Mobile Menu Button */}
              <Button
                variant="ghost"
                size="icon"
                className="lg:hidden rounded-2xl bg-white/5 backdrop-blur-xl border border-white/10 hover:bg-white/10 hover:border-white/30 transition-all duration-500"
                onClick={() => setIsMenuOpen(!isMenuOpen)}
              >
                {isMenuOpen ? <X className="h-5 w-5 text-white" /> : <Menu className="h-5 w-5 text-white" />}
              </Button>
            </div>
          </div>

          {/* Mobile Navigation */}
          {isMenuOpen && (
            <nav className="lg:hidden mt-6 pb-6 border-t border-white/10 pt-6 bg-black/20 backdrop-blur-3xl rounded-3xl border border-white/10 shadow-2xl">
              <div className="flex flex-col gap-6">
                {[
                  { href: "/", label: "Home" },
                  { href: "/#about", label: "About" },
                  { href: "/services", label: "Services" },
                  { href: "/#projects", label: "Projects" },
                  { href: "/contact", label: "Contact" },
                ].map((item) => (
                  <Link
                    key={item.label}
                    href={item.href}
                    className="text-sm font-medium text-white/80 hover:text-white transition-colors duration-300 px-4"
                  >
                    {item.label}
                  </Link>
                ))}
              </div>
            </nav>
          )}
        </div>
      </header>

      {/* Hero Section */}
      <section className="relative py-32 md:py-48 overflow-hidden bg-[#161d25]">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_20%_80%,rgba(255,255,255,0.1),transparent_70%)]"></div>
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_80%_20%,rgba(255,255,255,0.08),transparent_70%)]"></div>

        <div className="container mx-auto px-4 relative z-10">
          <div className="grid lg:grid-cols-12 gap-16 items-center">
            <div className="lg:col-span-7">
              <div className="mb-8">
                <div className="inline-flex items-center gap-3 bg-black/30 backdrop-blur-2xl border border-white/20 rounded-full px-6 py-3 mb-8 shadow-2xl">
                  <Target className="h-4 w-4 text-white" />
                  <span className="text-sm font-medium text-white">Digital Strategy</span>
                </div>
              </div>

              <h1 className="text-5xl md:text-7xl lg:text-8xl font-bold leading-[0.9] text-balance mb-8">
                <span className="block text-white">Strategic</span>
                <span className="block text-white">Digital</span>
                <span className="block text-white">Growth</span>
              </h1>

              <p className="text-xl md:text-2xl text-white/70 mb-12 text-pretty leading-relaxed max-w-2xl">
                Data-driven digital strategies that align with your business goals and deliver measurable results
                through strategic planning and execution.
              </p>

              <div className="flex flex-col sm:flex-row gap-6">
                <Link href="/contact">
                  <Button
                    size="lg"
                    className="bg-gradient-to-r from-white/15 to-white/10 backdrop-blur-xl border border-white/30 hover:border-white/50 text-white rounded-xl px-12 py-4 text-lg font-semibold transition-all duration-500 hover:scale-105 hover:shadow-2xl hover:shadow-white/20"
                  >
                    Start Your Project
                    <ArrowRight className="ml-3 h-5 w-5" />
                  </Button>
                </Link>
              </div>
            </div>

            <div className="lg:col-span-5">
              <Card className="p-8 bg-white/10 backdrop-blur-2xl border border-white/20 rounded-3xl">
                <div className="space-y-6">
                  <div className="flex items-center gap-4">
                    <div className="bg-white/20 p-3 rounded-2xl">
                      <Star className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <div className="text-2xl font-bold text-white">200%</div>
                      <div className="text-sm text-white/70">ROI Improvement</div>
                    </div>
                  </div>
                  <div className="flex items-center gap-4">
                    <div className="bg-white/20 p-3 rounded-2xl">
                      <TrendingUp className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <div className="text-2xl font-bold text-white">150%</div>
                      <div className="text-sm text-white/70">Growth Acceleration</div>
                    </div>
                  </div>
                  <div className="flex items-center gap-4">
                    <div className="bg-white/20 p-3 rounded-2xl">
                      <Clock className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <div className="text-2xl font-bold text-white">2-3 weeks</div>
                      <div className="text-sm text-white/70">Strategy Development</div>
                    </div>
                  </div>
                </div>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Service Details */}
      <section className="py-32 relative bg-white">
        <div className="container mx-auto px-4 relative z-10">
          <div className="grid lg:grid-cols-2 gap-16 items-center">
            <div>
              <h2 className="text-4xl md:text-6xl font-bold mb-6 text-black leading-tight">Strategy Services</h2>
              <p className="text-xl text-gray-600 mb-8 leading-relaxed">
                Comprehensive digital strategy consulting that helps businesses navigate the digital landscape and
                achieve sustainable growth.
              </p>

              <div className="space-y-4">
                {[
                  "Digital Transformation Planning",
                  "Market Research & Analysis",
                  "Competitive Intelligence",
                  "User Journey Mapping",
                  "Technology Roadmapping",
                  "Performance Metrics & KPIs",
                  "Growth Strategy Development",
                  "Implementation Guidance",
                ].map((feature, index) => (
                  <div key={index} className="flex items-center gap-3">
                    <CheckCircle className="h-5 w-5 text-green-500 flex-shrink-0" />
                    <span className="text-gray-700">{feature}</span>
                  </div>
                ))}
              </div>
            </div>

            <div className="space-y-8">
              <Card className="p-8 bg-gray-50 border-2 border-gray-200 rounded-3xl">
                <h3 className="text-2xl font-bold text-black mb-4">Strategy Areas</h3>
                <div className="grid grid-cols-2 gap-4">
                  {[
                    "SEO Strategy",
                    "Content Marketing",
                    "Social Media",
                    "PPC Advertising",
                    "Email Marketing",
                    "Conversion Optimization",
                    "Analytics Setup",
                    "Brand Positioning",
                  ].map((area, index) => (
                    <div key={index} className="bg-white p-3 rounded-lg border border-gray-200 text-center">
                      <span className="text-sm font-medium text-gray-700">{area}</span>
                    </div>
                  ))}
                </div>
              </Card>

              <Card className="p-8 bg-black text-white rounded-3xl">
                <h3 className="text-2xl font-bold mb-4">Investment</h3>
                <div className="text-4xl font-bold mb-2">Starting at $3,000</div>
                <p className="text-white/70 mb-6">Comprehensive strategy with implementation roadmap</p>
                <Link href="/contact">
                  <Button className="w-full bg-white text-black hover:bg-gray-100 rounded-2xl">
                    Get Quote
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Button>
                </Link>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-32 relative overflow-hidden bg-[#161d25]">
        <div className="container mx-auto px-4 relative z-10 text-center">
          <h2 className="text-4xl md:text-6xl font-bold mb-6 text-white leading-tight">Ready to Accelerate Growth?</h2>
          <p className="text-xl text-white/70 max-w-2xl mx-auto leading-relaxed mb-12">
            Develop a winning digital strategy that drives sustainable growth and positions your business for success.
          </p>
          <div className="flex flex-col sm:flex-row gap-6 justify-center">
            <Link href="/contact">
              <Button
                size="lg"
                className="bg-gradient-to-r from-white/15 to-white/10 backdrop-blur-xl border border-white/30 hover:border-white/50 text-white rounded-xl px-12 py-4 text-lg font-semibold transition-all duration-500 hover:scale-105 hover:shadow-2xl hover:shadow-white/20"
              >
                Start Your Project
                <ArrowRight className="ml-3 h-5 w-5" />
              </Button>
            </Link>
            <Link href="/services">
              <Button
                size="lg"
                variant="outline"
                className="bg-transparent border-2 border-white/30 text-white hover:bg-white/10 rounded-xl px-12 py-4 text-lg font-semibold transition-all duration-500 hover:scale-105"
              >
                View All Services
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </div>
  )
}
