"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.install = exports.printStats = void 0;
const plugin_alias_1 = __importDefault(require("@rollup/plugin-alias"));
const plugin_commonjs_1 = __importDefault(require("@rollup/plugin-commonjs"));
const plugin_json_1 = __importDefault(require("@rollup/plugin-json"));
const plugin_node_resolve_1 = __importDefault(require("@rollup/plugin-node-resolve"));
const es_module_lexer_1 = require("es-module-lexer");
const fs_1 = __importDefault(require("fs"));
const colors = __importStar(require("kleur/colors"));
const mkdirp_1 = __importDefault(require("mkdirp"));
const path_1 = __importDefault(require("path"));
const rimraf_1 = __importDefault(require("rimraf"));
const rollup_1 = require("rollup");
const rollup_plugin_node_polyfills_1 = __importDefault(require("rollup-plugin-node-polyfills"));
const plugin_replace_1 = __importDefault(require("@rollup/plugin-replace"));
const util_1 = __importDefault(require("util"));
const validate_npm_package_name_1 = __importDefault(require("validate-npm-package-name"));
const rollup_plugin_catch_fetch_1 = require("./rollup-plugins/rollup-plugin-catch-fetch");
const rollup_plugin_catch_unresolved_1 = require("./rollup-plugins/rollup-plugin-catch-unresolved");
const rollup_plugin_css_1 = require("./rollup-plugins/rollup-plugin-css");
const rollup_plugin_node_process_polyfill_1 = require("./rollup-plugins/rollup-plugin-node-process-polyfill");
const rollup_plugin_stats_1 = require("./rollup-plugins/rollup-plugin-stats");
const rollup_plugin_strip_source_mapping_1 = require("./rollup-plugins/rollup-plugin-strip-source-mapping");
const rollup_plugin_wrap_install_targets_1 = require("./rollup-plugins/rollup-plugin-wrap-install-targets");
const util_2 = require("./util");
__exportStar(require("./types"), exports);
var stats_1 = require("./stats");
Object.defineProperty(exports, "printStats", { enumerable: true, get: function () { return stats_1.printStats; } });
// Add popular CJS packages here that use "synthetic" named imports in their documentation.
// CJS packages should really only be imported via the default export:
//   import React from 'react';
// But, some large projects use named exports in their documentation:
//   import {useState} from 'react';
//
// We use "/index.js here to match the official package, but not any ESM aliase packages
// that the user may have installed instead (ex: react-esm).
const CJS_PACKAGES_TO_AUTO_DETECT = [
    'react/index.js',
    'react-dom/index.js',
    'react-dom/server.js',
    'react-is/index.js',
    'prop-types/index.js',
    'scheduler/index.js',
    'react-table',
    'chai/index.js',
];
// Rarely, a package will ship a broken "browser" package.json entrypoint.
// Ignore the "browser" entrypoint in those packages.
const BROKEN_BROWSER_ENTRYPOINT = ['@sheerun/mutationobserver-shim'];
function isImportOfPackage(importUrl, packageName) {
    return packageName === importUrl || importUrl.startsWith(packageName + '/');
}
function resolveNestedCondition(exportMapEntry) {
    // If this is a string or undefined we can skip checking for conditions
    switch (typeof exportMapEntry) {
        case 'string':
            return exportMapEntry;
        case 'undefined':
            return exportMapEntry;
    }
    return (resolveNestedCondition(exportMapEntry === null || exportMapEntry === void 0 ? void 0 : exportMapEntry.browser) ||
        resolveNestedCondition(exportMapEntry === null || exportMapEntry === void 0 ? void 0 : exportMapEntry.import) ||
        resolveNestedCondition(exportMapEntry === null || exportMapEntry === void 0 ? void 0 : exportMapEntry.default) ||
        resolveNestedCondition(exportMapEntry === null || exportMapEntry === void 0 ? void 0 : exportMapEntry.require) ||
        undefined);
}
function resolveExportsMap(packageManifest, exportsProp) {
    const exportMapEntry = packageManifest.exports[exportsProp];
    return resolveNestedCondition(exportMapEntry);
}
/**
 * Resolve a "webDependencies" input value to the correct absolute file location.
 * Supports both npm package names, and file paths relative to the node_modules directory.
 * Follows logic similar to Node's resolution logic, but using a package.json's ESM "module"
 * field instead of the CJS "main" field.
 */
function resolveWebDependency(dep, { cwd, packageLookupFields }) {
    // We first need to check for an export map in the package.json. If one exists, resolve to it.
    const [packageName, packageEntrypoint] = util_2.parsePackageImportSpecifier(dep);
    const [packageManifestLoc, packageManifest] = util_2.resolveDependencyManifest(packageName, cwd);
    if (packageManifestLoc && packageManifest && packageManifest.exports) {
        // If this is a non-main entry point
        if (packageEntrypoint) {
            const exportMapValue = resolveExportsMap(packageManifest, './' + packageEntrypoint);
            if (typeof exportMapValue !== 'string') {
                throw new Error(`Package "${packageName}" exists but package.json "exports" does not include entry for "./${packageEntrypoint}".`);
            }
            const loc = path_1.default.join(packageManifestLoc, '..', exportMapValue);
            return {
                type: util_2.getWebDependencyType(loc),
                loc,
            };
        }
        else {
            const exportMapValue = resolveExportsMap(packageManifest, '.');
            if (exportMapValue) {
                const loc = path_1.default.join(packageManifestLoc, '..', exportMapValue);
                return {
                    type: util_2.getWebDependencyType(loc),
                    loc,
                };
            }
        }
    }
    // if, no export map and dep points directly to a file within a package, return that reference.
    if (path_1.default.extname(dep) && !validate_npm_package_name_1.default(dep).validForNewPackages) {
        // For details on why we need to call fs.realpathSync.native here and other places, see
        // https://github.com/snowpackjs/snowpack/pull/999.
        const loc = fs_1.default.realpathSync.native(require.resolve(dep, { paths: [cwd] }));
        return {
            type: util_2.getWebDependencyType(loc),
            loc,
        };
    }
    // Otherwise, resolve directly to the dep specifier. Note that this supports both
    // "package-name" & "package-name/some/path" where "package-name/some/path/package.json"
    // exists at that lower path, that must be used to resolve. In that case, export
    // maps should not be supported.
    const [depManifestLoc, depManifest] = util_2.resolveDependencyManifest(dep, cwd);
    if (!depManifest) {
        try {
            const maybeLoc = fs_1.default.realpathSync.native(require.resolve(dep, { paths: [cwd] }));
            return {
                type: util_2.getWebDependencyType(maybeLoc),
                loc: maybeLoc,
            };
        }
        catch (err) {
            // Oh well, was worth a try
        }
    }
    if (!depManifestLoc || !depManifest) {
        throw new Error(`Package "${dep}" not found. Have you installed it? ${depManifestLoc ? depManifestLoc : ''}`);
    }
    if (depManifest.name &&
        (depManifest.name.startsWith('@reactesm') || depManifest.name.startsWith('@pika/react'))) {
        throw new Error(`React workaround packages no longer needed! Revert back to the official React & React-DOM packages.`);
    }
    let foundEntrypoint = [
        ...packageLookupFields,
        'browser:module',
        'module',
        'main:esnext',
        'jsnext:main',
    ]
        .map((e) => depManifest[e])
        .find(Boolean);
    if (!foundEntrypoint && !BROKEN_BROWSER_ENTRYPOINT.includes(packageName)) {
        foundEntrypoint = depManifest.browser;
    }
    // Some packages define "browser" as an object. We'll do our best to find the
    // right entrypoint in an entrypoint object, or fail otherwise.
    // See: https://github.com/defunctzombie/package-browser-field-spec
    if (typeof foundEntrypoint === 'object') {
        foundEntrypoint =
            foundEntrypoint[dep] ||
                foundEntrypoint['./index.js'] ||
                foundEntrypoint['./index'] ||
                foundEntrypoint['index.js'] ||
                foundEntrypoint['index'] ||
                foundEntrypoint['./'] ||
                foundEntrypoint['.'];
    }
    // If browser object is set but no relevant entrypoint is found, fall back to "main".
    if (!foundEntrypoint) {
        foundEntrypoint = depManifest.main;
    }
    // Sometimes packages don't give an entrypoint, assuming you'll fall back to "index.js".
    if (!foundEntrypoint && fs_1.default.existsSync(path_1.default.join(depManifestLoc, '../index.js'))) {
        foundEntrypoint = 'index.js';
    }
    // Some packages are types-only. If this is one of those packages, resolve with that.
    if (!foundEntrypoint && (depManifest.types || depManifest.typings)) {
        return { type: 'DTS', loc: undefined };
    }
    if (typeof foundEntrypoint !== 'string') {
        throw new Error(`"${dep}" has unexpected entrypoint: ${JSON.stringify(foundEntrypoint)}.`);
    }
    const loc = fs_1.default.realpathSync.native(require.resolve(path_1.default.join(depManifestLoc || '', '..', foundEntrypoint)));
    return {
        type: util_2.getWebDependencyType(loc),
        loc,
    };
}
function generateEnvObject(userEnv) {
    return {
        NODE_ENV: process.env.NODE_ENV || 'production',
        ...Object.keys(userEnv).reduce((acc, key) => {
            const value = userEnv[key];
            acc[key] = value === true ? process.env[key] : value;
            return acc;
        }, {}),
    };
}
function generateEnvReplacements(env) {
    return Object.keys(env).reduce((acc, key) => {
        acc[`process.env.${key}`] = JSON.stringify(env[key]);
        return acc;
    }, {});
}
const FAILED_INSTALL_MESSAGE = 'Install failed.';
function setOptionDefaults(_options) {
    const options = {
        cwd: process.cwd(),
        alias: {},
        logger: console,
        dest: 'web_modules',
        externalPackage: [],
        externalPackageEsm: [],
        polyfillNode: false,
        packageLookupFields: [],
        packageExportLookupFields: [],
        env: {},
        namedExports: [],
        rollup: {
            plugins: [],
            dedupe: [],
        },
        ..._options,
    };
    options.dest = path_1.default.resolve(options.cwd, options.dest);
    return options;
}
async function install(_installTargets, _options = {}) {
    var _a;
    const { cwd, alias: installAlias, lockfile, logger, dest: destLoc, namedExports, externalPackage, externalPackageEsm, sourceMap, env: userEnv, rollup: userDefinedRollup, treeshake: isTreeshake, polyfillNode, packageLookupFields, packageExportLookupFields, } = setOptionDefaults(_options);
    const env = generateEnvObject(userEnv);
    const installTargets = _installTargets.map((t) => typeof t === 'string' ? util_2.createInstallTarget(t) : t);
    const allInstallSpecifiers = new Set(installTargets
        .filter((dep) => !externalPackage.some((packageName) => isImportOfPackage(dep.specifier, packageName)))
        .map((dep) => dep.specifier)
        .map((specifier) => {
        const aliasEntry = util_2.findMatchingAliasEntry(installAlias, specifier);
        return aliasEntry && aliasEntry.type === 'package' ? aliasEntry.to : specifier;
    })
        .map((specifier) => specifier.replace(/(\/|\\)+$/, '')) // remove trailing slash from end of specifier (easier for Node to resolve)
        .sort((a, b) => a.localeCompare(b, undefined, { numeric: true })));
    const installEntrypoints = {};
    const assetEntrypoints = {};
    const importMap = { imports: {} };
    let dependencyStats = null;
    const skipFailures = false;
    const autoDetectNamedExports = [...CJS_PACKAGES_TO_AUTO_DETECT, ...namedExports];
    for (const installSpecifier of allInstallSpecifiers) {
        let targetName = util_2.getWebDependencyName(installSpecifier);
        let proxiedName = util_2.sanitizePackageName(targetName); // sometimes we need to sanitize webModule names, as in the case of tippy.js -> tippyjs
        if (lockfile && lockfile.imports[installSpecifier]) {
            installEntrypoints[targetName] = lockfile.imports[installSpecifier];
            importMap.imports[installSpecifier] = `./${proxiedName}.js`;
            continue;
        }
        try {
            const resolvedResult = resolveWebDependency(installSpecifier, {
                cwd,
                packageLookupFields,
            });
            if (resolvedResult.type === 'BUNDLE') {
                installEntrypoints[targetName] = resolvedResult.loc;
                importMap.imports[installSpecifier] = `./${proxiedName}.js`;
                Object.entries(installAlias)
                    .filter(([, value]) => value === installSpecifier)
                    .forEach(([key]) => {
                    importMap.imports[key] = `./${targetName}.js`;
                });
            }
            else if (resolvedResult.type === 'ASSET') {
                // add extension if missing
                const isMissingExt = path_1.default.extname(resolvedResult.loc) && !path_1.default.extname(proxiedName);
                if (isMissingExt) {
                    const ext = path_1.default.basename(resolvedResult.loc).replace(/[^.]+/, '');
                    targetName += ext;
                    proxiedName += ext;
                }
                assetEntrypoints[targetName] = resolvedResult.loc;
                importMap.imports[installSpecifier] = `./${proxiedName}`;
            }
            else if (resolvedResult.type === 'DTS') {
                // This is fine! Skip type-only packages
                logger.debug(`[${installSpecifier}] target points to a TS-only package.`);
            }
        }
        catch (err) {
            if (skipFailures) {
                continue;
            }
            throw err;
        }
    }
    if (Object.keys(installEntrypoints).length === 0 && Object.keys(assetEntrypoints).length === 0) {
        throw new Error(`No ESM dependencies found!
${colors.dim(`  At least one dependency must have an ESM "module" entrypoint. You can find modern, web-ready packages at ${colors.underline('https://www.skypack.dev')}`)}`);
    }
    await es_module_lexer_1.init;
    let isFatalWarningFound = false;
    const inputOptions = {
        input: installEntrypoints,
        context: userDefinedRollup.context,
        external: (id) => externalPackage.some((packageName) => isImportOfPackage(id, packageName)),
        treeshake: { moduleSideEffects: 'no-external' },
        plugins: [
            plugin_alias_1.default({
                entries: Object.entries(installAlias)
                    .filter(([, val]) => util_2.isPackageAliasEntry(val))
                    .map(([key, val]) => ({
                    find: key,
                    replacement: val,
                })),
            }),
            rollup_plugin_catch_fetch_1.rollupPluginCatchFetch(),
            plugin_node_resolve_1.default({
                mainFields: ['browser:module', 'module', 'browser', 'main'],
                extensions: ['.mjs', '.cjs', '.js', '.json'],
                // whether to prefer built-in modules (e.g. `fs`, `path`) or local ones with the same names
                preferBuiltins: true,
                dedupe: userDefinedRollup.dedupe || [],
                // @ts-ignore: Added in v11+ of this plugin
                exportConditions: packageExportLookupFields,
            }),
            plugin_json_1.default({
                preferConst: true,
                indent: '  ',
                compact: false,
                namedExports: true,
            }),
            rollup_plugin_css_1.rollupPluginCss(),
            plugin_replace_1.default(generateEnvReplacements(env)),
            plugin_commonjs_1.default({
                extensions: ['.js', '.cjs'],
                esmExternals: externalPackageEsm,
                requireReturnsDefault: 'auto',
            }),
            rollup_plugin_wrap_install_targets_1.rollupPluginWrapInstallTargets(!!isTreeshake, autoDetectNamedExports, installTargets, logger),
            rollup_plugin_stats_1.rollupPluginDependencyStats((info) => (dependencyStats = info)),
            rollup_plugin_node_process_polyfill_1.rollupPluginNodeProcessPolyfill(env),
            polyfillNode && rollup_plugin_node_polyfills_1.default(),
            ...(userDefinedRollup.plugins || []),
            rollup_plugin_catch_unresolved_1.rollupPluginCatchUnresolved(),
            rollup_plugin_strip_source_mapping_1.rollupPluginStripSourceMapping(),
        ].filter(Boolean),
        onwarn(warning) {
            // Log "unresolved" import warnings as an error, causing Snowpack to fail at the end.
            if (warning.code === 'PLUGIN_WARNING' &&
                warning.plugin === 'snowpack:rollup-plugin-catch-unresolved') {
                isFatalWarningFound = true;
                // Display posix-style on all environments, mainly to help with CI :)
                if (warning.id) {
                    const fileName = path_1.default.relative(cwd, warning.id).replace(/\\/g, '/');
                    logger.error(`${fileName}\n   ${warning.message}`);
                }
                else {
                    logger.error(`${warning.message}. See https://www.snowpack.dev/#troubleshooting`);
                }
                return;
            }
            const { loc, message } = warning;
            const logMessage = loc ? `${loc.file}:${loc.line}:${loc.column} ${message}` : message;
            // These warnings are usually harmless in packages, so don't show them by default.
            if (warning.code === 'CIRCULAR_DEPENDENCY' ||
                warning.code === 'NAMESPACE_CONFLICT' ||
                warning.code === 'THIS_IS_UNDEFINED') {
                logger.debug(logMessage);
            }
            else {
                logger.warn(logMessage);
            }
        },
    };
    const outputOptions = {
        dir: destLoc,
        format: 'esm',
        sourcemap: sourceMap,
        exports: 'named',
        entryFileNames: (chunk) => {
            const targetName = util_2.getWebDependencyName(chunk.name);
            const proxiedName = util_2.sanitizePackageName(targetName);
            return `${proxiedName}.js`;
        },
        chunkFileNames: 'common/[name]-[hash].js',
    };
    rimraf_1.default.sync(destLoc);
    if (Object.keys(installEntrypoints).length > 0) {
        try {
            logger.debug(`running installer with options: ${util_1.default.format(inputOptions)}`);
            const packageBundle = await rollup_1.rollup(inputOptions);
            logger.debug(`installing npm packages:\n    ${Object.keys(installEntrypoints).join('\n    ')}`);
            if (isFatalWarningFound) {
                throw new Error(FAILED_INSTALL_MESSAGE);
            }
            logger.debug(`writing install results to disk`);
            await packageBundle.write(outputOptions);
        }
        catch (_err) {
            const err = _err;
            const errFilePath = ((_a = err.loc) === null || _a === void 0 ? void 0 : _a.file) || err.id;
            if (!errFilePath) {
                throw err;
            }
            // NOTE: Rollup will fail instantly on most errors. Therefore, we can
            // only report one error at a time. `err.watchFiles` also exists, but
            // for now `err.loc.file` and `err.id` have all the info that we need.
            const failedExtension = path_1.default.extname(errFilePath);
            const suggestion = util_2.MISSING_PLUGIN_SUGGESTIONS[failedExtension] || err.message;
            // Display posix-style on all environments, mainly to help with CI :)
            const fileName = path_1.default.relative(cwd, errFilePath).replace(/\\/g, '/');
            logger.error(`Failed to load ${colors.bold(fileName)}\n  ${suggestion}`);
            throw new Error(FAILED_INSTALL_MESSAGE);
        }
    }
    mkdirp_1.default.sync(destLoc);
    await util_2.writeLockfile(path_1.default.join(destLoc, 'import-map.json'), importMap);
    for (const [assetName, assetLoc] of Object.entries(assetEntrypoints)) {
        const assetDest = `${destLoc}/${util_2.sanitizePackageName(assetName)}`;
        mkdirp_1.default.sync(path_1.default.dirname(assetDest));
        fs_1.default.copyFileSync(assetLoc, assetDest);
    }
    return {
        importMap,
        stats: dependencyStats,
    };
}
exports.install = install;
//# sourceMappingURL=index.js.map