import type { RenderedChunk } from 'rollup';
export interface DependencyTreeContext {
    chunk: RenderedChunk;
    dynamicImport: boolean;
}
export interface DependencyTreeOptions {
    filter?: (context: DependencyTreeContext) => boolean;
    walk?: (context: DependencyTreeContext) => boolean;
}
/**
 * Returns the transitive dependencies for a certain chunk
 * @param chunk - the chunk to get the dependencies of
 * @param chunks - all chunks
 * @param [opts] - the options to use
 * @return the transitive dependencies for the given chunk
 */
export declare function dependenciesForTree(chunk: RenderedChunk, allChunks: RenderedChunk[], opts?: DependencyTreeOptions): Set<RenderedChunk>;
