/// <reference types="node" />
import { IncomingHttpHeaders } from 'http';
import { ImportMap } from './util';
export { rollupPluginSkypack } from './rollup-plugin-remote-cdn';
export { SKYPACK_ORIGIN } from './util';
export declare function generateImportMap(webDependencies: Record<string, string | null>, inheritFromImportMap?: ImportMap): Promise<ImportMap>;
export declare function fetchCDN(resourceUrl: string, userAgent?: string): Promise<{
    body: string;
    headers: IncomingHttpHeaders;
    statusCode: number;
    isCached: boolean;
    isStale: boolean;
}>;
export declare type BuildNewPackageResponse = {
    error: Error;
    success: false;
} | {
    error: null;
    success: boolean;
};
export declare function buildNewPackage(spec: string, semverString?: string, userAgent?: string): Promise<BuildNewPackageResponse>;
export declare type LookupBySpecifierResponse = {
    error: Error;
} | {
    error: null;
    body: string;
    isCached: boolean;
    isStale: boolean;
    importStatus: string;
    importUrl: string;
    pinnedUrl: string | undefined;
    typesUrl: string | undefined;
};
export declare function lookupBySpecifier(spec: string, semverString?: string, userAgent?: string): Promise<LookupBySpecifierResponse>;
export declare function clearCache(): Promise<void[]>;
