"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = exports.command = exports.getInstallTargets = void 0;
const esinstall_1 = require("esinstall");
const colors = __importStar(require("kleur/colors"));
const path_1 = __importDefault(require("path"));
const perf_hooks_1 = require("perf_hooks");
const util_1 = __importDefault(require("util"));
const logger_1 = require("../logger");
const scan_imports_js_1 = require("../scan-imports.js");
const util_js_1 = require("../util.js");
const cwd = process.cwd();
async function getInstallTargets(config, scannedFiles) {
    const { knownEntrypoints } = config;
    let installTargets = [];
    if (knownEntrypoints) {
        installTargets.push(...scan_imports_js_1.scanDepList(knownEntrypoints, cwd));
    }
    // TODO: remove this if block; move logic inside scanImports
    if (scannedFiles) {
        installTargets.push(...(await scan_imports_js_1.scanImportsFromFiles(scannedFiles, config)));
    }
    else {
        installTargets.push(...(await scan_imports_js_1.scanImports(process.env.NODE_ENV === 'test', config)));
    }
    return installTargets;
}
exports.getInstallTargets = getInstallTargets;
async function command(commandOptions) {
    const { config } = commandOptions;
    logger_1.logger.debug('Starting install');
    const installTargets = await getInstallTargets(config);
    logger_1.logger.debug('Received install targets');
    if (installTargets.length === 0) {
        logger_1.logger.error('Nothing to install.');
        return;
    }
    logger_1.logger.debug('Running install command');
    await run({
        ...commandOptions,
        installTargets,
        shouldPrintStats: true,
        shouldWriteLockfile: true,
    }).catch((err) => {
        if (err.loc) {
            logger_1.logger.error(colors.red(colors.bold(`✘ ${err.loc.file}`)));
        }
        if (err.url) {
            logger_1.logger.error(colors.dim(`👉 ${err.url}`));
        }
        logger_1.logger.error(err.message || err);
        process.exit(1);
    });
}
exports.command = command;
async function run({ config, installTargets, shouldWriteLockfile, shouldPrintStats, }) {
    // start
    const installStart = perf_hooks_1.performance.now();
    logger_1.logger.info(colors.yellow('! installing dependencies...' +
        colors.cyan(config.experiments.source === 'local' ? '' : ` (source: ${config.experiments.source})`)));
    if (installTargets.length === 0) {
        return {
            importMap: { imports: {} },
            newLockfile: null,
            stats: null,
        };
    }
    let newLockfile = null;
    const finalResult = await esinstall_1.install(installTargets, {
        cwd,
        lockfile: newLockfile || undefined,
        alias: config.alias,
        logger: {
            debug: (...args) => logger_1.logger.debug(util_1.default.format(...args)),
            log: (...args) => logger_1.logger.info(util_1.default.format(...args)),
            warn: (...args) => logger_1.logger.warn(util_1.default.format(...args)),
            error: (...args) => logger_1.logger.error(util_1.default.format(...args)),
        },
        ...config.installOptions,
    });
    logger_1.logger.debug('Install ran successfully!');
    if (shouldWriteLockfile && newLockfile) {
        await util_js_1.writeLockfile(path_1.default.join(cwd, 'snowpack.lock.json'), newLockfile);
        logger_1.logger.debug('Successfully wrote lockfile');
    }
    // finish
    const installEnd = perf_hooks_1.performance.now();
    const depList = (finalResult.importMap && Object.keys(finalResult.importMap.imports)) || [];
    logger_1.logger.info(`${depList.length
        ? colors.green(`✔`) + ' install complete!'
        : 'install skipped (nothing to install)'} ${colors.dim(`[${((installEnd - installStart) / 1000).toFixed(2)}s]`)}`);
    if (shouldPrintStats && finalResult.stats) {
        logger_1.logger.info(esinstall_1.printStats(finalResult.stats));
    }
    return {
        importMap: finalResult.importMap,
        newLockfile,
        stats: finalResult.stats,
    };
}
exports.run = run;
//# sourceMappingURL=install.js.map