"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cli = exports.getUrlForFile = exports.loadLockfile = exports.createConfiguration = exports.loadAndValidateConfig = exports.buildProject = exports.startDevServer = void 0;
const colors = __importStar(require("kleur/colors"));
const path_1 = __importDefault(require("path"));
const util_1 = __importDefault(require("util"));
const yargs_parser_1 = __importDefault(require("yargs-parser"));
const add_rm_1 = require("./commands/add-rm");
const init_1 = require("./commands/init");
const build_1 = require("./commands/build");
const install_1 = require("./commands/install");
const dev_1 = require("./commands/dev");
const logger_1 = require("./logger");
const config_1 = require("./config");
const util_js_1 = require("./util.js");
__exportStar(require("./types/snowpack"), exports);
// Stable API (remember to include all in "./index.esm.js" wrapper)
var dev_2 = require("./commands/dev");
Object.defineProperty(exports, "startDevServer", { enumerable: true, get: function () { return dev_2.startDevServer; } });
var build_2 = require("./commands/build");
Object.defineProperty(exports, "buildProject", { enumerable: true, get: function () { return build_2.buildProject; } });
var config_js_1 = require("./config.js");
Object.defineProperty(exports, "loadAndValidateConfig", { enumerable: true, get: function () { return config_js_1.loadConfigurationForCLI; } });
Object.defineProperty(exports, "createConfiguration", { enumerable: true, get: function () { return config_js_1.createConfiguration; } });
var util_js_2 = require("./util.js");
Object.defineProperty(exports, "loadLockfile", { enumerable: true, get: function () { return util_js_2.readLockfile; } });
var file_urls_1 = require("./build/file-urls");
Object.defineProperty(exports, "getUrlForFile", { enumerable: true, get: function () { return file_urls_1.getUrlForFile; } });
const cwd = process.cwd();
function printHelp() {
    logger_1.logger.info(`
${colors.bold(`snowpack`)} - A faster build system for the modern web.

  Snowpack is best configured via config file.
  But, most configuration can also be passed via CLI flags.
  📖 ${colors.dim('https://www.snowpack.dev/#configuration')}

${colors.bold('Commands:')}
  snowpack init          Create a new project config file.
  snowpack dev           Develop your app locally.
  snowpack build         Build your app for production.
  snowpack add [package] Add a package to your lockfile (import map).
  snowpack rm [package]  Remove a package from your lockfile.
  snowpack install       (Deprecated) Install web-ready dependencies.

${colors.bold('Flags:')}
  --config [path]        Set the location of your project config file.
  --help                 Show this help message.
  --version              Show the current version.
  --reload               Clear Snowpack's local cache (troubleshooting).
  --verbose              View debug info (where available)
  --quiet                Don’t output anything (dev server will still log minimally)
    `.trim());
}
async function cli(args) {
    // parse CLI flags
    const cliFlags = yargs_parser_1.default(args, {
        array: ['install', 'env', 'exclude', 'externalPackage'],
    });
    if (cliFlags.verbose) {
        logger_1.logger.level = 'debug';
    }
    if (cliFlags.quiet) {
        logger_1.logger.level = 'silent';
    }
    if (cliFlags.help) {
        printHelp();
        process.exit(0);
    }
    if (cliFlags.version) {
        logger_1.logger.info(require('../package.json').version);
        process.exit(0);
    }
    if (cliFlags.reload) {
        logger_1.logger.info(colors.yellow('! clearing cache...'));
        await util_js_1.clearCache();
    }
    // Load the current package manifest
    let pkgManifest;
    try {
        pkgManifest = require(path_1.default.join(cwd, 'package.json'));
    }
    catch (err) {
        logger_1.logger.error(`package.json not found in directory: ${cwd}. Run \`npm init -y\` to create one.`);
        process.exit(1);
    }
    const cmd = cliFlags['_'][2];
    logger_1.logger.debug(`run command: ${cmd}`);
    if (!cmd) {
        printHelp();
        process.exit(1);
    }
    // Set this early -- before config loading -- so that plugins see it.
    if (cmd === 'build') {
        process.env.NODE_ENV = process.env.NODE_ENV || 'production';
    }
    if (cmd === 'dev') {
        process.env.NODE_ENV = process.env.NODE_ENV || 'development';
    }
    const config = config_1.loadConfigurationForCLI(cliFlags, pkgManifest);
    logger_1.logger.debug(`config loaded: ${util_1.default.format(config)}`);
    const lockfile = await util_js_1.readLockfile(cwd);
    logger_1.logger.debug(`lockfile ${lockfile ? 'loaded.' : 'not loaded'}`);
    const commandOptions = {
        cwd,
        config,
        lockfile,
    };
    if (cmd === 'add') {
        await add_rm_1.addCommand(cliFlags['_'][3], commandOptions);
        return process.exit(0);
    }
    if (cmd === 'rm') {
        await add_rm_1.rmCommand(cliFlags['_'][3], commandOptions);
        return process.exit(0);
    }
    if (cliFlags['_'].length > 3) {
        logger_1.logger.error(`Unexpected multiple commands`);
        process.exit(1);
    }
    if (cmd === 'init') {
        await init_1.command(commandOptions);
        return process.exit(0);
    }
    if (cmd === 'build') {
        await build_1.command(commandOptions);
        return process.exit(0);
    }
    if (cmd === 'dev') {
        await dev_1.command(commandOptions);
        return process.exit(0);
    }
    if (cmd === 'install') {
        await install_1.command(commandOptions);
        return process.exit(0);
    }
    logger_1.logger.error(`Unrecognized command: ${cmd}`);
    process.exit(1);
}
exports.cli = cli;
//# sourceMappingURL=index.js.map