'use strict';

var sade = require('sade');
var _package = require('./package.js');
require('path');
require('module');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
	if (e && e.__esModule) return e;
	var n = Object.create(null);
	if (e) {
		Object.keys(e).forEach(function (k) {
			if (k !== 'default') {
				var d = Object.getOwnPropertyDescriptor(e, k);
				Object.defineProperty(n, k, d.get ? d : {
					enumerable: true,
					get: function () {
						return e[k];
					}
				});
			}
		});
	}
	n['default'] = e;
	return Object.freeze(n);
}

var sade__default = /*#__PURE__*/_interopDefaultLegacy(sade);

let config;

try {
	config = _package.load_config();
} catch (error) {
	const adjective = error.code === 'ENOENT' ? 'Missing' : 'Malformed';

	console.error(_package.$.bold().red(`${adjective} svelte.config.js`));
	console.error(_package.$.grey(error.stack));
	process.exit(1);
}

function handle_error(error) {
	console.log(_package.$.bold().red(`> ${error.message}`));
	console.log(_package.$.gray(error.stack));
	process.exit(1);
}

async function launch(port) {
	const { exec } = await Promise.resolve().then(function () { return /*#__PURE__*/_interopNamespace(require('child_process')); });
	exec(`${process.platform == 'win32' ? 'start' : 'open'} http://localhost:${port}`);
}

const prog = sade__default['default']('svelte').version(_package.version);

prog
	.command('dev')
	.describe('Start a development server')
	.option('-p, --port', 'Port', 3000)
	.option('-o, --open', 'Open a browser tab', false)
	.action(async ({ port, open }) => {
		const { dev } = await Promise.resolve().then(function () { return require('./index.js'); });

		try {
			const watcher = await dev({ port, config });

			watcher.on('stdout', (data) => {
				process.stdout.write(data);
			});

			watcher.on('stderr', (data) => {
				process.stderr.write(data);
			});

			console.log(_package.$.bold().cyan(`> Listening on http://localhost:${watcher.port}`));
			if (open) launch(watcher.port);
		} catch (error) {
			handle_error(error);
		}
	});

prog
	.command('build')
	.describe('Create a deployment-ready version of your app')
	.action(async () => {
		const { build } = await Promise.resolve().then(function () { return require('./index2.js'); });

		try {
			await build(config);
		} catch (error) {
			handle_error(error);
		}
	});

prog
	.command('start')
	.describe('Serve an already-built app')
	.option('-p, --port', 'Port', 3000)
	.option('-o, --open', 'Open a browser tab', false)
	.action(async ({ port, open }) => {
		const { start } = await Promise.resolve().then(function () { return require('./index3.js'); });

		try {
			await start({ port, config });

			console.log(_package.$.bold().cyan(`> Listening on http://localhost:${port}`));
			if (open) if (open) launch(port);
		} catch (error) {
			handle_error(error);
		}
	});

prog.parse(process.argv, { unknown: (arg) => `Unknown option: ${arg}` });
//# sourceMappingURL=cli.js.map
