"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dependenciesForTree = void 0;
/**
 * Returns the transitive dependencies for a certain chunk
 * @param chunk - the chunk to get the dependencies of
 * @param chunks - all chunks
 * @param [opts] - the options to use
 * @return the transitive dependencies for the given chunk
 */
function dependenciesForTree(chunk, allChunks, opts) {
    var result = new Set();
    var visited = new Set();
    dependenciesForTrees(result, visited, chunk, allChunks, false, opts);
    return result;
}
exports.dependenciesForTree = dependenciesForTree;
function addChunk(ctx, result, opts) {
    if (!opts || !opts.filter || opts.filter(ctx)) {
        result.add(ctx.chunk);
    }
}
var visitKey = function (ctx) { return ctx.chunk.fileName + ':' + ctx.dynamicImport; };
function dependenciesForTrees(result, visited, chunkToResolve, allChunks, dynamicImport, opts) {
    var ctx = { chunk: chunkToResolve, dynamicImport: dynamicImport };
    if (opts && opts.walk && !opts.walk(ctx)) {
        return;
    }
    // need to hand the case where we come across a chunk as a dynamic import and static import
    visited.add(visitKey(ctx));
    addChunk(ctx, result, opts);
    chunkToResolve.imports.concat(chunkToResolve.dynamicImports).forEach(function (fileName) {
        var chunk = allChunks.find(function (c) { return c.fileName === fileName; });
        if (!chunk) {
            return;
        }
        // avoid cycles
        var dynamicImport = chunkToResolve.imports.indexOf(chunk.fileName) < 0;
        if (visited.has(visitKey({ chunk: chunk, dynamicImport: dynamicImport }))) {
            return;
        }
        dependenciesForTrees(result, visited, chunk, allChunks, dynamicImport, opts);
    });
}
