"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rmCommand = exports.addCommand = void 0;
const httpie_1 = require("httpie");
const colors_1 = require("kleur/colors");
const path_1 = __importDefault(require("path"));
const skypack_1 = require("skypack");
const logger_1 = require("../logger");
const util_1 = require("../util");
async function addCommand(addValue, commandOptions) {
    const { cwd, lockfile } = commandOptions;
    let [pkgName, pkgSemver] = addValue.split('@');
    const installMessage = pkgSemver ? `${pkgName}@${pkgSemver}` : pkgName;
    logger_1.logger.info(`fetching ${colors_1.cyan(installMessage)} from Skypack CDN...`);
    if (!pkgSemver || pkgSemver === 'latest') {
        const { data } = await httpie_1.send('GET', `http://registry.npmjs.org/${pkgName}/latest`);
        pkgSemver = `^${data.version}`;
    }
    logger_1.logger.info(`adding ${colors_1.cyan(colors_1.underline(`https://cdn.skypack.dev/${pkgName}@${pkgSemver}`))} to your project lockfile. ${colors_1.dim('(snowpack.lock.json)')}`);
    const addedDependency = { [pkgName]: pkgSemver };
    const newLockfile = {
        ...(await skypack_1.generateImportMap(addedDependency, lockfile || undefined)),
        dependencies: {
            ...lockfile === null || lockfile === void 0 ? void 0 : lockfile.dependencies,
            ...addedDependency,
        },
    };
    await util_1.writeLockfile(path_1.default.join(cwd, 'snowpack.lock.json'), newLockfile);
}
exports.addCommand = addCommand;
async function rmCommand(addValue, commandOptions) {
    var _a;
    const { cwd, lockfile } = commandOptions;
    let [pkgName] = addValue.split('@');
    logger_1.logger.info(`removing ${colors_1.cyan(pkgName)} from project lockfile...`);
    const newLockfile = {
        ...(await skypack_1.generateImportMap({ [pkgName]: null }, lockfile || undefined)),
        dependencies: (_a = lockfile === null || lockfile === void 0 ? void 0 : lockfile.dependencies) !== null && _a !== void 0 ? _a : {},
    };
    delete newLockfile.dependencies[pkgName];
    await util_1.writeLockfile(path_1.default.join(cwd, 'snowpack.lock.json'), newLockfile);
}
exports.rmCommand = rmCommand;
//# sourceMappingURL=add-rm.js.map