import { Plugin as RollupPlugin } from 'rollup';
import { AbstractLogger, DependencyStatsOutput, EnvVarReplacements, ImportMap, InstallTarget } from './types';
export * from './types';
export { printStats } from './stats';
interface InstallOptions {
    cwd: string;
    alias: Record<string, string>;
    lockfile?: ImportMap;
    logger: AbstractLogger;
    verbose?: boolean;
    dest: string;
    env: EnvVarReplacements;
    treeshake?: boolean;
    polyfillNode: boolean;
    sourceMap?: boolean | 'inline';
    externalPackage: string[];
    externalPackageEsm: string[];
    packageLookupFields: string[];
    packageExportLookupFields: string[];
    namedExports: string[];
    rollup: {
        context?: string;
        plugins?: RollupPlugin[];
        dedupe?: string[];
    };
}
declare type PublicInstallOptions = Partial<InstallOptions>;
export { PublicInstallOptions as InstallOptions };
export declare type InstallResult = {
    importMap: ImportMap;
    stats: DependencyStatsOutput;
};
export declare function install(_installTargets: (InstallTarget | string)[], _options?: PublicInstallOptions): Promise<InstallResult>;
