"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rollupPluginWrapInstallTargets = void 0;
const fs_1 = __importDefault(require("fs"));
const colors = __importStar(require("kleur/colors"));
const path_1 = __importDefault(require("path"));
const vm2_1 = require("vm2");
const util_1 = require("../util");
const is_valid_identifier_1 = __importDefault(require("is-valid-identifier"));
// Use CJS intentionally here! ESM interface is async but CJS is sync, and this file is sync
const { parse } = require('cjs-module-lexer');
/**
 * rollup-plugin-wrap-install-targets
 *
 * How it works:
 * 1. An array of "install targets" are passed in, describing all known imports + metadata.
 * 2. If isTreeshake: Known imports are marked for tree-shaking by appending 'snowpack-wrap:' to the input value.
 * 3. If autoDetectPackageExports match: Also mark for wrapping, and use automatic export detection.
 * 4. On load, we return a false virtual file for all "snowpack-wrap:" inputs.
 *    a. That virtual file contains only `export ... from 'ACTUAL_FILE_PATH';` exports
 *    b. Rollup uses those exports to drive its tree-shaking algorithm.
 *    c. Rollup uses those exports to inform its "namedExports" for Common.js entrypoints.
 */
function rollupPluginWrapInstallTargets(isTreeshake, autoDetectPackageExports, installTargets, logger) {
    const installTargetSummaries = {};
    const cjsScannedNamedExports = new Map();
    /**
     * Runtime analysis: High Fidelity, but not always successful.
     * `require()` the CJS file inside of Node.js to load the package and detect it's runtime exports.
     * TODO: Safe to remove now that cjsAutoDetectExportsUntrusted() is getting smarter?
     */
    function cjsAutoDetectExportsTrusted(normalizedFileLoc) {
        try {
            const mod = require(normalizedFileLoc);
            // skip analysis for non-object modules, these can only be the default export.
            if (!mod || mod.constructor !== Object) {
                return;
            }
            // Collect and filter all properties of the object as named exports.
            return Object.keys(mod).filter((imp) => imp !== 'default' && imp !== '__esModule');
        }
        catch (err) {
            logger.debug(`✘ Runtime CJS auto-detection for ${colors.bold(normalizedFileLoc)} unsuccessful. Falling back to static analysis. ${err.message}`);
        }
    }
    /**
     * Attempt #2: Static analysis: Lower Fidelity, but safe to run on anything.
     * Get the exports that we scanned originally using static analysis. This is meant to run on
     * any file (not only CJS) but it will only return an array if CJS exports were found.
     */
    function cjsAutoDetectExportsUntrusted(filename, visited = new Set()) {
        const isMainEntrypoint = visited.size === 0;
        // Prevent infinite loops via circular dependencies.
        if (visited.has(filename)) {
            return [];
        }
        else {
            visited.add(filename);
        }
        const fileContents = fs_1.default.readFileSync(filename, 'utf-8');
        try {
            // Attempt 1 - CJS: Run cjs-module-lexer to statically analyze exports.
            let { exports, reexports } = parse(fileContents);
            // If re-exports were detected (`exports.foo = require(...)`) then resolve them here.
            let resolvedReexports = [];
            if (reexports.length > 0) {
                resolvedReexports = [].concat.apply([], reexports
                    .map((e) => cjsAutoDetectExportsUntrusted(require.resolve(e, { paths: [path_1.default.dirname(filename)] }), visited))
                    .filter(util_1.isTruthy));
            }
            // Attempt 2 - UMD: Run the file in a sandbox to dynamically analyze exports.
            // This will only work on UMD and very simple CJS files (require not supported).
            // Uses VM2 to run safely sandbox untrusted code (no access no Node.js primitives, just JS).
            if (isMainEntrypoint && exports.length === 0 && reexports.length === 0) {
                const vm = new vm2_1.VM({ wasm: false, fixAsync: false });
                exports = Object.keys(vm.run('const exports={}; const module={exports}; ' + fileContents + ';; module.exports;'));
                // Verify that all of these are valid identifiers. Otherwise when we attempt to
                // reexport it will produce invalid js like `import { a, b, 0, ) } from 'foo';
                const allValid = exports.every((identifier) => is_valid_identifier_1.default(identifier));
                if (!allValid) {
                    exports = [];
                }
            }
            // Resolve and flatten all exports into a single array, and remove invalid exports.
            return Array.from(new Set([...exports, ...resolvedReexports])).filter((imp) => imp !== 'default' && imp !== '__esModule');
        }
        catch (err) {
            // Safe to ignore, this is usually due to the file not being CJS.
            logger.debug(`cjsAutoDetectExportsUntrusted error: ${err.message}`);
        }
    }
    return {
        name: 'snowpack:wrap-install-targets',
        // Mark some inputs for tree-shaking.
        buildStart(inputOptions) {
            const input = inputOptions.input;
            for (const [key, val] of Object.entries(input)) {
                if (util_1.isRemoteUrl(val)) {
                    continue;
                }
                if (!util_1.isJavaScript(val)) {
                    continue;
                }
                const allInstallTargets = installTargets.filter((imp) => util_1.getWebDependencyName(imp.specifier) === key);
                const installTargetSummary = allInstallTargets.reduce((summary, imp) => {
                    summary.all = summary.all || imp.all;
                    summary.default = summary.default || imp.default || imp.all;
                    summary.namespace = summary.namespace || imp.namespace || imp.all;
                    summary.named = [...(summary.named || []), ...imp.named];
                    return summary;
                }, {});
                installTargetSummaries[val] = installTargetSummary;
                const normalizedFileLoc = val.split(path_1.default.win32.sep).join(path_1.default.posix.sep);
                const isExplicitAutoDetect = autoDetectPackageExports.some((p) => normalizedFileLoc.includes(`node_modules/${p}${p.endsWith('.js') ? '' : '/'}`));
                const cjsExports = isExplicitAutoDetect
                    ? cjsAutoDetectExportsTrusted(val)
                    : cjsAutoDetectExportsUntrusted(val);
                if (cjsExports && cjsExports.length > 0) {
                    cjsScannedNamedExports.set(normalizedFileLoc, cjsExports);
                    input[key] = `snowpack-wrap:${val}`;
                }
                if (isTreeshake && !installTargetSummary.all) {
                    input[key] = `snowpack-wrap:${val}`;
                }
            }
        },
        resolveId(source) {
            if (source.startsWith('snowpack-wrap:')) {
                return source;
            }
            return null;
        },
        load(id) {
            if (!id.startsWith('snowpack-wrap:')) {
                return null;
            }
            const fileLoc = id.substring('snowpack-wrap:'.length);
            // Reduce all install targets into a single "summarized" install target.
            const installTargetSummary = installTargetSummaries[fileLoc];
            let uniqueNamedExports = Array.from(new Set(installTargetSummary.named));
            const normalizedFileLoc = fileLoc.split(path_1.default.win32.sep).join(path_1.default.posix.sep);
            const scannedNamedExports = cjsScannedNamedExports.get(normalizedFileLoc);
            if (scannedNamedExports && (!isTreeshake || installTargetSummary.namespace)) {
                uniqueNamedExports = scannedNamedExports || [];
                installTargetSummary.default = true;
            }
            const result = `
        ${installTargetSummary.namespace ? `export * from '${normalizedFileLoc}';` : ''}
        ${installTargetSummary.default
                ? `import __pika_web_default_export_for_treeshaking__ from '${normalizedFileLoc}'; export default __pika_web_default_export_for_treeshaking__;`
                : ''}
        ${`export {${uniqueNamedExports.join(',')}} from '${normalizedFileLoc}';`}
      `;
            return result;
        },
    };
}
exports.rollupPluginWrapInstallTargets = rollupPluginWrapInstallTargets;
//# sourceMappingURL=rollup-plugin-wrap-install-targets.js.map