import { SnowpackBuildMap, SnowpackConfig, SnowpackPlugin } from '../types/snowpack';
export interface BuildFileOptions {
    isDev: boolean;
    isSSR: boolean;
    isHmrEnabled: boolean;
    plugins: SnowpackPlugin[];
    sourceMaps: boolean;
}
export declare function getInputsFromOutput(fileLoc: string, plugins: SnowpackPlugin[]): string[];
export declare function runPipelineOptimizeStep(buildDirectory: string, { plugins }: BuildFileOptions): Promise<null>;
export declare function runPipelineCleanupStep({ plugins }: SnowpackConfig): Promise<void>;
/** Core Snowpack file pipeline builder */
export declare function buildFile(srcURL: URL, buildFileOptions: BuildFileOptions): Promise<SnowpackBuildMap>;
